<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\StockItemController;
use App\Http\Controllers\Api\DailySaleController;
use App\Http\Controllers\Api\DashboardController;

// Public routes
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);

// Protected routes
Route::middleware('auth:sanctum')->group(function () {
    // Auth
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/user', [AuthController::class, 'user']);

    // Categories
    Route::apiResource('categories', CategoryController::class);

    // Products
    Route::apiResource('products', ProductController::class);

    // Stock Items
    Route::get('/stock-items/alerts', [StockItemController::class, 'alerts']);
    Route::post('/stock-items/{stockItem}/stock-in', [StockItemController::class, 'stockIn']);
    Route::post('/stock-items/{stockItem}/stock-out', [StockItemController::class, 'stockOut']);
    Route::apiResource('stock-items', StockItemController::class);

    // Daily Sales
    Route::apiResource('daily-sales', DailySaleController::class)->except(['update']);

    // Dashboard & Analytics
    Route::prefix('dashboard')->group(function () {
        Route::get('/stats', [DashboardController::class, 'stats']);
        Route::get('/sales-trend', [DashboardController::class, 'salesTrend']);
        Route::get('/top-products', [DashboardController::class, 'topProducts']);
        Route::get('/category-distribution', [DashboardController::class, 'categoryDistribution']);
    });
});
