import {
  Dialog,
  DialogContent,
  DialogHeader,
  DialogTitle,
} from "@/components/ui/dialog";
import { DailySale } from "@/lib/api";
import InvoiceView from "./InvoiceView";

interface InvoiceDialogProps {
  open: boolean;
  onOpenChange: (open: boolean) => void;
  sale: DailySale | null;
}

const InvoiceDialog = ({ open, onOpenChange, sale }: InvoiceDialogProps) => {
  if (!sale) return null;

  return (
    <Dialog open={open} onOpenChange={onOpenChange} modal={true}>
      <DialogContent className="max-w-5xl max-h-[90vh] overflow-y-auto invoice-dialog">
        <DialogHeader className="no-print">
          <DialogTitle>Invoice - {sale.invoiceNumber || sale.date}</DialogTitle>
        </DialogHeader>
        <InvoiceView sale={sale} />
      </DialogContent>
    </Dialog>
  );
};

export default InvoiceDialog;
