<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreDailySaleRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'date' => 'required|date',
            'customer_name' => 'nullable|string|max:255',
            'customer_phone' => 'nullable|string|max:20',
            'customer_address' => 'nullable|string|max:500',
            'total_tp' => 'required|numeric|min:0',
            'total_dp' => 'required|numeric|min:0',
            'total_profit' => 'required|numeric',
            'due_amount' => 'required|numeric|min:0',
            'paid_amount' => 'required|numeric|min:0',
            'discount' => 'required|numeric|min:0',
            'net_profit' => 'required|numeric',
            'items' => 'required|array|min:1',
            'items.*.item_name' => 'required|string|max:255',
            'items.*.qty' => 'required|integer|min:1',
            'items.*.dp' => 'required|numeric|min:0',
            'items.*.tp' => 'required|numeric|min:0',
            'items.*.total_tp' => 'required|numeric|min:0',
            'items.*.total_dp' => 'required|numeric|min:0',
            'items.*.profit' => 'required|numeric',
        ];
    }
}
