<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class StockItem extends Model
{
    protected $fillable = [
        'item_name',
        'vendor',
        'stock_in_date',
        'stock_in_qty',
        'stock_out_date',
        'stock_out_qty',
        'cost_price',
        'stock_balance',
        'selling_price',
        'total_sales_rate',
        'total_stock_rate',
    ];

    protected $casts = [
        'stock_in_date' => 'date',
        'stock_out_date' => 'date',
        'stock_in_qty' => 'integer',
        'stock_out_qty' => 'integer',
        'stock_balance' => 'integer',
        'cost_price' => 'decimal:2',
        'selling_price' => 'decimal:2',
        'total_sales_rate' => 'decimal:2',
        'total_stock_rate' => 'decimal:2',
    ];

    // Scopes for filtering
    public function scopeOutOfStock(Builder $query): Builder
    {
        return $query->where('stock_balance', 0);
    }

    public function scopeLowStock(Builder $query, int $threshold = 10): Builder
    {
        return $query->where('stock_balance', '>', 0)
                     ->where('stock_balance', '<=', $threshold);
    }
}
