<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\StockItem;

class StockItemSeeder extends Seeder
{
    public function run(): void
    {
        $stockItems = [
            ['item_name' => 'Pen InVisible', 'stock_in_date' => '2025-12-27', 'stock_in_qty' => 111, 'stock_out_date' => '2026-01-15', 'stock_out_qty' => 58, 'cost_price' => 15, 'stock_balance' => 53, 'selling_price' => 20, 'total_sales_rate' => 1160, 'total_stock_rate' => 795],
            ['item_name' => 'Design Roller', 'stock_in_date' => '2025-12-27', 'stock_in_qty' => 80, 'stock_out_date' => '2026-01-15', 'stock_out_qty' => 37, 'cost_price' => 15, 'stock_balance' => 43, 'selling_price' => 25, 'total_sales_rate' => 925, 'total_stock_rate' => 645],
            ['item_name' => 'Naruto UNO Card L', 'stock_in_date' => '2025-12-27', 'stock_in_qty' => 10, 'stock_out_date' => '2026-01-15', 'stock_out_qty' => 8, 'cost_price' => 38, 'stock_balance' => 2, 'selling_price' => 55, 'total_sales_rate' => 440, 'total_stock_rate' => 76],
            ['item_name' => 'Pokimon Card (Large)', 'stock_in_date' => '2025-12-27', 'stock_in_qty' => 100, 'stock_out_date' => '2026-01-15', 'stock_out_qty' => 100, 'cost_price' => 7.5, 'stock_balance' => 0, 'selling_price' => 12, 'total_sales_rate' => 1200, 'total_stock_rate' => 0],
            ['item_name' => 'Pokimon Card (Small)', 'stock_in_date' => '2025-12-27', 'stock_in_qty' => 200, 'stock_out_date' => '2026-01-15', 'stock_out_qty' => 58, 'cost_price' => 3.5, 'stock_balance' => 142, 'selling_price' => 5, 'total_sales_rate' => 290, 'total_stock_rate' => 497],
            ['item_name' => 'X0', 'stock_in_date' => '2025-12-27', 'stock_in_qty' => 100, 'stock_out_date' => '2026-01-15', 'stock_out_qty' => 56, 'cost_price' => 17, 'stock_balance' => 44, 'selling_price' => 30, 'total_sales_rate' => 1680, 'total_stock_rate' => 748],
            ['item_name' => 'Ball Game', 'stock_in_date' => '2025-12-27', 'stock_in_qty' => 120, 'stock_out_date' => '2026-01-15', 'stock_out_qty' => 31, 'cost_price' => 28, 'stock_balance' => 89, 'selling_price' => 40, 'total_sales_rate' => 1240, 'total_stock_rate' => 2492],
            ['item_name' => 'Sticky Note', 'stock_in_date' => '2025-12-27', 'stock_in_qty' => 60, 'stock_out_date' => '2026-01-15', 'stock_out_qty' => 60, 'cost_price' => 22, 'stock_balance' => 0, 'selling_price' => 25, 'total_sales_rate' => 1500, 'total_stock_rate' => 0],
            ['item_name' => 'Mobile Stand (Bangla)', 'stock_in_date' => '2025-12-27', 'stock_in_qty' => 50, 'stock_out_date' => '2026-01-15', 'stock_out_qty' => 18, 'cost_price' => 4, 'stock_balance' => 32, 'selling_price' => 8, 'total_sales_rate' => 144, 'total_stock_rate' => 128],
            ['item_name' => 'Finger Sliper (1 Color)', 'stock_in_date' => '2025-12-27', 'stock_in_qty' => 900, 'stock_out_date' => '2026-01-15', 'stock_out_qty' => 353, 'cost_price' => 4.4, 'stock_balance' => 547, 'selling_price' => 7, 'total_sales_rate' => 2471, 'total_stock_rate' => 2406.8],
        ];

        foreach ($stockItems as $item) {
            StockItem::create($item);
        }
    }
}
